<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [App\Http\Controllers\HomeController::class, 'index'])->name('index');
Route::get('/find/user', [App\Http\Controllers\HomeController::class, 'findUser'])->name('findUser');
Route::get('/send/cod/email/{email}', [App\Http\Controllers\HomeController::class, 'confirmEmail'])->name('confirmEmail');
Route::get('/send/cod/tel/{tel}', [App\Http\Controllers\HomeController::class, 'confirmTel'])->name('confirmTel');

Route::middleware(['checkapi'])->group(function () {
    // Route::get('/update/pac', [App\Http\Controllers\HomeController::class, 'updatePac'])->name('updatePac');

    Route::get('/m', function () { return view('menu'); })->name('loggedMenu');
    Route::get('/m1', [App\Http\Controllers\MenuController::class, 'redirectMenu'])->name('redirectMenu');

    /* AGENDAMIENTO */
    Route::get('/age/get/sed', [App\Http\Controllers\AgendamientoController::class, 'GetSedes'])->name('GetSedes');
    Route::get('/age/get/auto', [App\Http\Controllers\AgendamientoController::class, 'GetAutorizaciones'])->name('GetAutorizaciones');
    Route::get('/age/get/esp', [App\Http\Controllers\AgendamientoController::class, 'GetEspecialidades'])->name('GetEspecialidades');
    Route::get('/age/get/med', [App\Http\Controllers\AgendamientoController::class, 'GetMedicos'])->name('GetMedicos');
    Route::get('/age/get/med/age', [App\Http\Controllers\AgendamientoController::class, 'GetAgenda'])->name('GetAgenda');
    Route::get('/age/get/age/hor', [App\Http\Controllers\AgendamientoController::class, 'GetHoras'])->name('GetHoras');
    Route::get('/age/post/cit', [App\Http\Controllers\AgendamientoController::class, 'PostCita'])->name('PostCita');

    /* CANCELAR */
    Route::get('/can/get/cit', [App\Http\Controllers\CancelarController::class, 'GetCit'])->name('GetCit');
    Route::get('/can/post', [App\Http\Controllers\CancelarController::class, 'PostCancel'])->name('PostCancel');
});
