@extends('layouts.main')

@section('head')
    <style>
        /* styles.css */
        table {
            table-layout: fixed;
            width: 100%;
        }

        table th,
        table td {
            text-align: center;
            vertical-align: middle;
        }
    </style>
@endsection

@section('content')
    <div class="card mb-4">
        <div class="card-body">

            <div id="div_pasos">

                <div><a type="buttom" href="{{ route('loggedMenu') }}" class="btn btn-danger"><i class="fas fa-arrow-left"></i>
                        Menú</a></div>

                <div class="d-sm-flex align-items-center row mb-4">
                    <div class="col-12">
                        <h1 class="h3 mb-0 text-center text-gray-800"><strong>Cancelación de citas</strong></h1>
                    </div>
                </div>
                {{-- PASO 1 --}}
                <div id="paso_1">
                    <div class="col-12">
                        <h4 class="text-center mb-0 text-gray-800">Sr/a <span
                                class="span_nombre_usuario">{{ Session::get('name') }}</span>
                            <br>
                            Elija la cita que desea cancelar:
                        </h4>
                        <br>
                    </div>
                    <div class="col-12">
                        <table class="table" id="agendaTablaCitas">
                            <thead>
                                <tr>
                                    <th scope="col" style="text-align: center">Doctor</th>
                                    <th scope="col" style="text-align: center">Especialidad</th>
                                    <th scope="col" style="text-align: center">Sede</th>
                                    <th scope="col" style="text-align: center">Fecha y hora</th>
                                    <th scope="col" style="text-align: center">Seleccionar</th>
                                </tr>
                            </thead>
                            <tbody name="tbodyCitas">

                            </tbody>
                        </table>
                    </div>

                    <div class="boton_sig">
                        <button type="button" id="btn_sig_paso_1" class="btn btn-danger">Siguiente <i
                                class="fas fa-arrow-right"></i></button>
                    </div>

                </div>

                {{-- PASO 2 --}}
                <div id="paso_2" style="display:none;">
                    <h4 class="text-center mb-0 text-gray-800">Sr/a <span
                            class="span_nombre_usuario">{{ Session::get('name') }}</span>
                        <br>
                        Elija el motivo de la cancelación:
                    </h4>
                    <br>
                    @foreach ($motivosCancelacion as $mtc)
                        <div class="container">
                            <div class="form-check">
                                <input class="form-check-input" style="width:15px;height:15px"
                                    value="{{ $mtc->Cod_Motivo_202 }}" name="motivo_cancelacion" type="radio">
                                <label class="form-check-label" style="font-size: 20px;">
                                    {{ $mtc->Desc_Motivo_202 }}
                                </label>
                            </div>
                        </div>
                    @endforeach

                    <div class="row">
                        <div class="col-6" align="right">
                            <button type="button" class="btn btn-danger btn_ant_paso" data-paso="1"><i
                                    class="fas fa-arrow-left"></i> Anterior</button>
                        </div>
                        <div class="col-6">
                            <button type="button" id="btn_sig_paso_2" class="btn btn-danger">Siguiente <i
                                    class="fas fa-arrow-right"></i></button>
                        </div>
                    </div>
                </div>

                {{-- PASO 3 --}}
                <div id="paso_3" style="display:none;">
                    <h4 class="text-center mb-0 text-gray-800">Sr/a <span
                            class="span_nombre_usuario">{{ Session::get('name') }}</span>
                        <br>
                        Está seguro de cancelar su cita: <br>
                        <span id="spanMessageCancelar"></span>
                    </h4>
                    <br>
                    <div class="container">
                        <div class="form-check">
                            <input class="form-check-input" style="width:15px;height:15px" value="1"
                                name="confirmacion_cancelacion" type="radio">
                            <label class="form-check-label" style="font-size: 20px;">
                                Si
                            </label>
                        </div>
                    </div>
                    <div class="container">
                        <div class="form-check">
                            <input class="form-check-input" style="width:15px;height:15px" value="0"
                                name="confirmacion_cancelacion" type="radio">
                            <label class="form-check-label" style="font-size: 20px;">
                                No
                            </label>
                        </div>
                    </div>
                    <br>

                    <div class="row">
                        <div class="col-6" align="right">
                            <button type="button" class="btn btn-danger btn_ant_paso" data-paso="2"><i
                                    class="fas fa-arrow-left"></i> Anterior</button>
                        </div>
                        <div class="col-6">
                            <button type="button" id="btn_sig_paso_3" class="btn btn-danger">Siguiente <i
                                    class="fas fa-arrow-right"></i></button>
                        </div>
                    </div>
                </div>

                {{-- PASO 4 --}}
                <div id="paso_4" style="display:none;">
                    <h4 class="text-center mb-0 text-gray-800">Sr/a <span
                            class="span_nombre_usuario">{{ Session::get('name') }}</span>
                        <br>
                        <span id="spanCancelSuccess"></span>
                    </h4>
                    <br>
                    <div class="boton_sig">
                        <a type="button" href="{{ route('loggedMenu') }}" class="btn btn-danger">Finalizar</a>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection

@section('scripts')
    <script src="{{ asset('js/funciones/cancelacion_cita.js') }}"></script>
@endsection
