const btn_sig_paso_1 = document.getElementById('btn_sig_paso_1');
const btn_sig_paso_2 = document.getElementById('btn_sig_paso_2');
const btn_sig_paso_3 = document.getElementById('btn_sig_paso_3');
const btn_sig_paso_4 = document.getElementById('btn_sig_paso_4');

var globEspecialidad;
var globCitas;
var globCitaSelect;
var globMotivoCancelacion;

var globCodEmpresa;
var globDescEmpresa;
var globCodSede;
var globDescSede;
var globNCita;
var globTipoIdentificacion;
var globIdentificacion;
var globCodContrato;
var globDescContrato;
var globCodEspecialidad;
var globDescEspecialidad;
var globCodMedico;
var globDescMedico;
var globFechaCita;
var globHoraCita;
var globEstadoCita;
var globTipocita;

const btnsAntPaso = $(".btn_ant_paso");

btnsAntPaso.on("click", function () {
    const pasoAnterior = parseInt($(this).data("paso"));
    $(`#paso_${pasoAnterior + 1}`).css("display", "none");
    $(`#paso_${pasoAnterior}`).css("display", "block");
});

window.addEventListener('load', function () {

    $.ajax({
        url: '../../can/get/cit',
        type: 'GET',
        dataType: 'json',
        beforeSend: function () {
            $('#loaderModal').css('display', 'block');
        },
        success: function (response) {
            $('#loaderModal').css('display', 'none');
            if (response != "1") { // SE ENCONTRAROS MEDICOS
                var listado3 = $("[name=tbodyCitas]");
                listado3.empty();
                globCitas = response;
                var dataTable = $('#agendaTablaCitas').DataTable();
                dataTable.destroy();
                var dataTable = $('#agendaTablaCitas').DataTable({
                    language: {
                        processing:     "Procesando...",
                        search:         "Buscar:",
                        lengthMenu:     "Mostrar _MENU_ elementos",
                        info:           "Mostrando desde _START_ al _END_ de _TOTAL_ elementos",
                        infoEmpty:      "Mostrando ningún elemento.",
                        infoFiltered:   "(filtrado _MAX_ elementos total)",
                        infoPostFix:    "",
                        loadingRecords: "Cargando registros...",
                        zeroRecords:    "Ningún dato disponible en esta tabla",
                        emptyTable:     "No hay datos disponibles en esta tabla",
                        paginate: {
                            first:      "Primero",
                            previous:   "Anterior",
                            next:       "Siguiente",
                            last:       "Último"
                        },
                        aria: {
                            sortAscending:  ": Activar para ordenar la columna de manera ascendente",
                            sortDescending: ": Activar para ordenar la columna de manera descendente"
                        }
                    }
                });
                dataTable.clear().draw();
                for (var i = 0; i < globCitas.length; i++) {
                    var item = globCitas[i];
                    dataTable.row.add([
                        item.Desc_Medico,
                        item.Desc_Especialidad,
                        item.Desc_Sede,
                        item.Fecha_Cita + ' ' + item.Hora_Cita,
                        '<div class="form-check">' +
                        '<input class="form-check-input" style="width:15px;height:15px" value="' + i + '" name="cita_cancelar" type="radio">' +
                        '<label class="form-check-label" style="font-size: 20px;"></label>' +
                        '</div>'
                    ]).draw();
                }
            } else { // NO SE ENCONTRAROS ESPECIALIDADES
                Swal.fire({
                    icon: 'warning',
                    title: 'No se encontraron citas reservadas!',
                    showConfirmButton: true,
                        confirmButtonText: 'Aceptar',
                        confirmButtonColor: '#d42946',
                        timerProgressBar: false,
                })
            }
        },
        error: function (jqXHR) { // ERROR AJAX
            $('#loaderModal').css('display', 'none');
            console.log('error!');
            Swal.fire({
                timer: 4000,
                icon: 'error',
                title: 'Ha ocurrido un error!',
                showConfirmButton: true,
                        confirmButtonText: 'Aceptar',
                        confirmButtonColor: '#d42946',
                        timerProgressBar: false,
            })
        }
    });

});

btn_sig_paso_1.addEventListener('click', function () {
    const cita_cancelar = $('input[name="cita_cancelar"]:checked').val();
    if (cita_cancelar != null) {
        globCitaSelect = cita_cancelar;

        globCodEmpresa = globCitas[cita_cancelar].Cod_Empresa;
        globDescEmpresa = globCitas[cita_cancelar].Desc_Empresa;
        globCodSede = globCitas[cita_cancelar].Cod_Sede;
        globDescSede = globCitas[cita_cancelar].Desc_Sede;
        globNCita = globCitas[cita_cancelar].N_Cita;
        globTipoIdentificacion = globCitas[cita_cancelar].Tipo_Identificacion;
        globIdentificacion = globCitas[cita_cancelar].Identificacion;
        globCodContrato = globCitas[cita_cancelar].Cod_Contrato;
        globDescContrato = globCitas[cita_cancelar].Desc_Contrato;
        globCodEspecialidad = globCitas[cita_cancelar].Cod_Especialidad;
        globDescEspecialidad = globCitas[cita_cancelar].Desc_Especialidad;
        globCodMedico = globCitas[cita_cancelar].Cod_Medico;
        globDescMedico = globCitas[cita_cancelar].Desc_Medico;
        globFechaCita = globCitas[cita_cancelar].Fecha_Cita;
        globHoraCita = globCitas[cita_cancelar].Hora_Cita;
        globEstadoCita = globCitas[cita_cancelar].Estado_Cita;
        globTipocita = globCitas[cita_cancelar].Tipo_cita;

        $("#paso_1").css("display", "none");
        $("#paso_2").css("display", "block");
    } else {
        Swal.fire({
            icon: 'error',
            title: 'Por favor, selecciona una cita',
            showConfirmButton: true,
                        confirmButtonText: 'Aceptar',
                        confirmButtonColor: '#d42946',            timerProgressBar: false,
        })
    }
});

btn_sig_paso_2.addEventListener('click', function () {
    const motivo_cancelacion = $('input[name="motivo_cancelacion"]:checked').val();

    if (motivo_cancelacion != null) {

        globMotivoCancelacion = motivo_cancelacion;

        document.getElementById("spanMessageCancelar").innerHTML = globDescEspecialidad.toLowerCase()+" "+globFechaCita.toLowerCase()+" a las "+globHoraCita+" con el médico "+globDescMedico;

        $("#paso_2").css("display", "none");
        $("#paso_3").css("display", "block");
    } else {
        Swal.fire({
            icon: 'error',
            title: 'Por favor, selecciona una opción',
            showConfirmButton: true,
                        confirmButtonText: 'Aceptar',
                        confirmButtonColor: '#d42946',            timerProgressBar: false,
        })
    }
});

btn_sig_paso_3.addEventListener('click', function () {
    const confirmacion_cancelacion = $('input[name="confirmacion_cancelacion"]:checked').val();

    if (confirmacion_cancelacion == "1") {

        const sendData = {
            "CodEmpresa": globCodEmpresa,
            "DescEmpresa": globDescEmpresa,
            "CodSede": globCodSede,
            "DescSede": globDescSede,
            "NCita": globNCita,
            "TipoIdentificacion": globTipoIdentificacion,
            "Identificacion": globIdentificacion,
            "CodContrato": globCodContrato,
            "DescContrato": globDescContrato,
            "CodEspecialidad": globCodEspecialidad,
            "DescEspecialidad": globDescEspecialidad,
            "CodMedico": globCodMedico,
            "DescMedico": globDescMedico,
            "FechaCita": globFechaCita,
            "HoraCita": globHoraCita,
            "EstadoCita": globEstadoCita,
            "Tipocita": globTipocita,
            "MotivoCancelacion": globMotivoCancelacion
        };

        $.ajax({
            url: '../../can/post',
            type: 'GET',
            dataType: 'json',
            data: sendData,
            beforeSend: function () {
                $('#loaderModal').css('display', 'block');
            },
            success: function (response) {
                $('#loaderModal').css('display', 'none');
                if (response != "1") { // SE ENCONTRAROS MEDICOS
                    document.getElementById('spanCancelSuccess').innerHTML = response.message;
                    $("#paso_3").css("display", "none");
                    $("#paso_4").css("display", "block");
                } else { // NO SE ENCONTRAROS ESPECIALIDADES
                    Swal.fire({
                        icon: 'warning',
                        title: response.message,
                        showConfirmButton: true,
                        confirmButtonText: 'Aceptar',
                        confirmButtonColor: '#d42946',                        timerProgressBar: false,
                    })
                }
            },
            error: function (jqXHR) { // ERROR AJAX
                $('#loaderModal').css('display', 'none');
                console.log('error!');
                Swal.fire({
                    icon: 'error',
                    title: 'Ha ocurrido un error!',
                    showConfirmButton: true,
                        confirmButtonText: 'Aceptar',
                        confirmButtonColor: '#d42946',                    timerProgressBar: false,
                })
            }
        });

    } else if (confirmacion_cancelacion == "0") {
        window.location.href = "/m";
    } else {
        Swal.fire({
            icon: 'error',
            title: 'Por favor, selecciona una opción',
            showConfirmButton: true,
                        confirmButtonText: 'Aceptar',
                        confirmButtonColor: '#d42946',            timerProgressBar: false,
        })
    }
});

