const btn_ant_paso_1 = document.getElementById('btn_ant_paso_1');
const btn_ant_paso_2 = document.getElementById('btn_ant_paso_2');
const btn_ant_paso_auto = document.getElementById('btn_ant_paso_auto');
const btn_ant_paso_3 = document.getElementById('btn_ant_paso_3');
const btn_ant_paso_4 = document.getElementById('btn_ant_paso_4');
const btn_ant_paso_5 = document.getElementById('btn_ant_paso_5');

const btn_sig_paso_0 = document.getElementById('btn_sig_paso_0');
const btn_sig_paso_1 = document.getElementById('btn_sig_paso_1');
const btn_sig_paso_2 = document.getElementById('btn_sig_paso_2');
const btn_sig_paso_auto = document.getElementById('btn_sig_paso_auto');
const btn_sig_paso_3 = document.getElementById('btn_sig_paso_3');
const btn_sig_paso_4 = document.getElementById('btn_sig_paso_4');
const btn_sig_paso_5 = document.getElementById('btn_sig_paso_5');

/* VAR EXTRAIDAS */
var globSedes;
var globSedeSelect;
var globSedeNombre;
var globCodEmpresa;

var globMedicosData;

/* VAR ESPECIALIDAD */
var globEspecialidad;
var globCodEspecialidad;
var globNomEspecialidad;
var globCodCups;

/* VAR AUTORIZACION */
var globAuto;
var globAutorizacionN;
var globAutorizacionCodEspecialidad;
var globAutorizacionDescEspecialidad;
var globAutorizacionCodProcedimiento;
var globAutorizacionNROAUTORIZACION;
var globAutorizacionFechaInicioVigencia;
var globAutorizacionFechaFinVigencia;
var globAutorizacionSedeDestino;

/* VAR CITA */
var globTipCita;
var globNeedAuto;
var globMedicoSelect;
var globMedicoNombre;
var globFechaSelect;
var globHoras;
var globHorasSelect;
var globHoraInit;
var globHoraFinish;
var globCodConsultorio;
var globCitTime;

const btnsAntPaso = $(".btn_ant_paso");

/* FUNCIONES DE BOTONES */

/* BTN ATRAS */

btn_ant_paso_1.addEventListener('click', function () {
    $("#paso_1").css("display", "none");
    $("#paso_0").css("display", "block");
});

btn_ant_paso_2.addEventListener('click', function () {
    $("#paso_2").css("display", "none");
    $("#paso_1").css("display", "block");
});

btn_ant_paso_auto.addEventListener('click', function () {
    $("#paso_auto").css("display", "none");
    $("#paso_2").css("display", "block");
});

btn_ant_paso_3.addEventListener('click', function () {
    if (globNeedAuto == "S") {
        $("#paso_3").css("display", "none");
        $("#paso_auto").css("display", "block");
    } else if (globNeedAuto == "N") {
        $("#paso_3").css("display", "none");
        $("#paso_2").css("display", "block");
    }
});

btn_ant_paso_4.addEventListener('click', function () {
    $("#paso_4").css("display", "none");
    $("#paso_3").css("display", "block");
});

btn_ant_paso_5.addEventListener('click', function () {
    $("#paso_5").css("display", "none");
    $("#paso_4").css("display", "block");
});

/* AGENDAMIENTO */

window.addEventListener('load', function () {
    $.ajax({
        url: '../../age/get/sed',
        type: 'GET',
        dataType: 'json',
        beforeSend: function () {
            $('#loaderModal').css('display', 'block');
        },
        success: function (response) {
            $('#loaderModal').css('display', 'none');
            if (response != "1") { // SE ENCONTRAROS MEDICOS
                var listado3 = $("[name=tbodySedes]");
                listado3.empty();
                globSedes = response;
                var dataTable = $('#agendaTablaSedes').DataTable({
                    language: {
                        processing: "Procesando...",
                        search: "Buscar:",
                        lengthMenu: "Mostrar _MENU_ elementos",
                        info: "Mostrando desde _START_ al _END_ de _TOTAL_ elementos",
                        infoEmpty: "Mostrando ningún elemento.",
                        infoFiltered: "(filtrado _MAX_ elementos total)",
                        infoPostFix: "",
                        loadingRecords: "Cargando registros...",
                        zeroRecords: "Ningún dato disponible en esta tabla",
                        emptyTable: "No hay datos disponibles en esta tabla",
                        paginate: {
                            first: "Primero",
                            previous: "Anterior",
                            next: "Siguiente",
                            last: "Último"
                        },
                        aria: {
                            sortAscending: ": Activar para ordenar la columna de manera ascendente",
                            sortDescending: ": Activar para ordenar la columna de manera descendente"
                        }
                    }
                });
                dataTable.clear().draw();
                for (var i = 0; i < globSedes.length; i++) {
                    var item = globSedes[i];
                    dataTable.row.add([
                        item.Desc_sede,
                        '<div class="form-check">' +
                        '<input class="form-check-input" style="width:15px;height:15px" value="' + item.Cod_ede + '" name="sedes" type="radio">' +
                        '<label class="form-check-label" style="font-size: 20px;"></label>' +
                        '</div>'
                    ]).draw();
                }
            } else { // NO SE ENCONTRAROS ESPECIALIDADES
                Swal.fire({
                    icon: 'warning',
                    title: 'No se encontraron citas reservadas!',
                    showConfirmButton: true,
                    confirmButtonText: 'Aceptar',
                    confirmButtonColor: '#d42946',
                    timerProgressBar: false,
                })
            }
        },
        error: function (jqXHR) { // ERROR AJAX
            $('#loaderModal').css('display', 'none');
            console.log('error!');
            Swal.fire({
                timer: 4000,
                icon: 'error',
                title: 'Ha ocurrido un error!',
                showConfirmButton: true,
                confirmButtonText: 'Aceptar',
                confirmButtonColor: '#d42946',
                timerProgressBar: false,
            })
        }
    });
});

btn_sig_paso_0.addEventListener('click', function () {
    const sede = $('input[name="sedes"]:checked').val();
    if (sede != null) { // OPCION SELECCIONADA
        globSedeSelect = sede;
        globSedeNombre = globSedes.find(sedeS => sedeS.Cod_ede === sede).Desc_sede;
        globCodEmpresa = globSedes.find(sedeS => sedeS.Cod_ede === sede).Cod_Empresa;
        console.log(globSedes.find(sedeS => sedeS.Cod_ede === sede));

        $("#paso_0").css("display", "none");
        $("#paso_1").css("display", "block");
    } else { // SELECCIONE UNA OPCION
        Swal.fire({
            icon: 'error',
            title: 'Por favor, selecciona una opción',
            showConfirmButton: true,
            confirmButtonText: 'Aceptar',
            confirmButtonColor: '#d42946',
            timerProgressBar: false,
        })
    }
});

btn_sig_paso_1.addEventListener('click', function () {
    const tipoCita = $('input[name="tipo_cita"]:checked').val();

    if (tipoCita != null) {

        switch (tipoCita) {
            case "1":
                globTipCita = "N";
                break;
            case "2":
                globTipCita = "S";
                break;
            default:
                Swal.fire({
                    timer: 2000,
                    icon: 'error',
                    title: 'Error Check',
                    showConfirmButton: true,
                    confirmButtonText: 'Aceptar',
                    confirmButtonColor: '#d42946',
                    timerProgressBar: false,
                })
                break;
        }

        const dataSend = {
            "sede": globSedeSelect
        }

        $.ajax({
            url: '../../age/get/esp',
            type: 'GET',
            dataType: 'json',
            data: dataSend,
            beforeSend: function () {
                $('#loaderModal').css('display', 'block');
            },
            success: function (response) {
                $('#loaderModal').css('display', 'none');
                if (response != "1") { // SE ENCONTRAROS ESPECIALIDADES
                    globEspecialidades = response
                    var dataTable = $('#agendaTablaEspecialidades').DataTable();
                    dataTable.destroy();
                    var dataTable = $('#agendaTablaEspecialidades').DataTable({
                        language: {
                            processing: "Procesando...",
                            search: "Buscar:",
                            lengthMenu: "Mostrar _MENU_ elementos",
                            info: "Mostrando desde _START_ al _END_ de _TOTAL_ elementos",
                            infoEmpty: "Mostrando ningún elemento.",
                            infoFiltered: "(filtrado _MAX_ elementos total)",
                            infoPostFix: "",
                            loadingRecords: "Cargando registros...",
                            zeroRecords: "Ningún dato disponible en esta tabla",
                            emptyTable: "No hay datos disponibles en esta tabla",
                            paginate: {
                                first: "Primero",
                                previous: "Anterior",
                                next: "Siguiente",
                                last: "Último"
                            },
                            aria: {
                                sortAscending: ": Activar para ordenar la columna de manera ascendente",
                                sortDescending: ": Activar para ordenar la columna de manera descendente"
                            }
                        }
                    });
                    dataTable.clear().draw();
                    for (var i = 0; i < globEspecialidades.length; i++) {
                        var item = globEspecialidades[i];
                        dataTable.row.add([
                            item.Nom_Especialidad,
                            '<div class="form-check">' +
                            '<input class="form-check-input" style="width:15px;height:15px" value="' + i + '" name="especialidad_cita" type="radio">' +
                            '<label class="form-check-label" style="font-size: 20px;"></label>' +
                            '</div>'
                        ]).draw();
                    }
                    $("#paso_1").css("display", "none");
                    $("#paso_2").css("display", "block");
                } else { // NO SE ENCONTRAROS ESPECIALIDADES
                    Swal.fire({
                        icon: 'warning',
                        title: 'No se encontraron autorización!',
                        showConfirmButton: true,
                        confirmButtonText: 'Aceptar',
                        confirmButtonColor: '#d42946',
                        timerProgressBar: false,
                    })
                }
            },
            error: function (jqXHR) { // ERROR AJAX
                $('#loaderModal').css('display', 'none');
                console.log('error!');
                Swal.fire({
                    icon: 'error',
                    title: 'Ha ocurrido un error!',
                    showConfirmButton: true,
                    confirmButtonText: 'Aceptar',
                    confirmButtonColor: '#d42946',
                    timerProgressBar: false,
                })
            }
        });

    } else {
        Swal.fire({
            icon: 'error',
            title: 'Por favor, selecciona una opción',
            showConfirmButton: true,
            confirmButtonText: 'Aceptar',
            confirmButtonColor: '#d42946',
            timerProgressBar: false,
        })
    }

});

btn_sig_paso_2.addEventListener('click', function () {
    const especialidad_cita = $('input[name="especialidad_cita"]:checked').val();
    if (especialidad_cita != null) { // OPCION SELECCIONADA
        globCodEspecialidad = globEspecialidades[especialidad_cita].Cod_Especialidad;
        globNomEspecialidad = globEspecialidades[especialidad_cita].Nom_Especialidad;
        globNeedAuto = globEspecialidades[especialidad_cita].Autorizacion;
        //globCodEmpresa = globEspecialidades[especialidad_cita].Cod_Empresa;
        
        console.log(globEspecialidades[especialidad_cita]);
        
        if (globNeedAuto == "S") { // Necesita autorizacion
        
            const dataSend = {
                "especialidad": globCodEspecialidad
            }
            $.ajax({
                url: '../../age/get/auto',
                type: 'GET',
                dataType: 'json',
                data: dataSend,
                beforeSend: function () {
                    $('#loaderModal').css('display', 'block');
                },
                success: function (response) {
                    $('#loaderModal').css('display', 'none');

                    if (response == "10") {
                        Swal.fire({
                            icon: 'warning',
                            title: '¡No puede agendar más citas de esta especialidad este mes!',
                            showConfirmButton: true,
                            confirmButtonText: 'Aceptar',
                            confirmButtonColor: '#d42946',
                            timerProgressBar: false,
                        })
                        $('input[name="tipo_cita"]:checked').prop("checked", false);
                    }

                    if (response == "11") {
                        Swal.fire({
                            icon: 'warning',
                            title: '¡No puede agendar más citas de esta especialidad este año!',
                            showConfirmButton: true,
                            confirmButtonText: 'Aceptar',
                            confirmButtonColor: '#d42946',
                            timerProgressBar: false,
                        })
                        $('input[name="tipo_cita"]:checked').prop("checked", false);
                    }

                    if (response != "1") {
                        /* SE ENCONTRAROS AUTORIZACIONES */
                        var listado = $("[name=tbody_auto]");
                        listado.empty();
                        globAuto = response;

                        for (var i = 0; i < globAuto.length; i++) {
                            var item = globAuto[i];
                            listado.append(
                                '<tr>' +
                                '<td scope="row" style="text-align: center">' + item['NRO_AUTORIZACION'] + '</td>' +
                                '<td style="text-align: center">' + item['Desc_Especialidad'] + '</td>' +
                                '<td style="text-align: center">' +
                                '<div class="form-check">' +
                                '<input class="form-check-input" style="width:15px;height:15px" value="' + i + '" name="autorizacion_cita" type="radio">' +
                                '<label class="form-check-label" style="font-size: 20px;"></label>' +
                                '</div>' +
                                '</td>' +
                                '</tr>'
                            );
                        }

                        $("#paso_2").css("display", "none");
                        $("#paso_auto").css("display", "block");
                    } else {
                        /* NO SE ENCONTRAROS AUTORIZACIONES */
                        Swal.fire({
                            icon: 'warning',
                            title: 'No se encontraron autorización!',
                            showConfirmButton: true,
                            confirmButtonText: 'Aceptar',
                            confirmButtonColor: '#d42946',
                            timerProgressBar: false,
                        })
                        $('input[name="tipo_cita"]:checked').prop("checked", false);
                    }
                },
                error: function (jqXHR) {
                    /* ERROR AJAX */
                    $('#loaderModal').css('display', 'none');
                    $('input[name="tipo_cita"]:checked').prop("checked", false);
                    console.log('error!');
                    Swal.fire({
                        icon: 'error',
                        title: 'Ha ocurrido un error!',
                        showConfirmButton: true,
                        confirmButtonText: 'Aceptar',
                        confirmButtonColor: '#d42946',
                        timerProgressBar: false,
                    })
                }
            });

        } else if (globNeedAuto == "N") { // No nececita autorizacion
        
            if(globTipCita == "N"){
                globCodCups = globEspecialidades[especialidad_cita].cod_cups_Control;
            }else if(globTipCita == "S"){
                globCodCups = globEspecialidades[especialidad_cita].cod_cups;
            }
            
            const dataSend = {
                "especialidad": globCodEspecialidad,
                "sede": globSedeSelect
            }
            $.ajax({
                url: '../../age/get/med',
                type: 'GET',
                dataType: 'json',
                data: dataSend,
                beforeSend: function () {
                    $('#loaderModal').css('display', 'block');
                },
                success: function (response) {
                    $('#loaderModal').css('display', 'none');
                    if (response != "1") { // SE ENCONTRAROS MEDICOS
                        var listado4 = $("[name=tbody_medicos]");
                        listado4.empty();
                        globMedicosData = response;
                        
                        if (response == "10") {
                            Swal.fire({
                                icon: 'warning',
                                title: '¡No puede agendar más citas de esta especialidad este mes!',
                                showConfirmButton: true,
                                confirmButtonText: 'Aceptar',
                                confirmButtonColor: '#d42946',
                                timerProgressBar: false,
                            })
                            $('input[name="tipo_cita"]:checked').prop("checked", false);
                        }else if (response == "11") {
                            Swal.fire({
                                icon: 'warning',
                                title: '¡No puede agendar más citas de esta especialidad este año!',
                                showConfirmButton: true,
                                confirmButtonText: 'Aceptar',
                                confirmButtonColor: '#d42946',
                                timerProgressBar: false,
                            })
                            $('input[name="tipo_cita"]:checked').prop("checked", false);
                        }else{
                            for (var i = 0; i < globMedicosData.length; i++) {
                                var item = globMedicosData[i];
                                listado4.append(
                                    '<tr>' +
                                    '<th scope="row" style="text-align: center">' + item['Nom_Medico'] + '</th>' +
                                    '<td style="text-align: center">' +
                                    '<div class="form-check">' +
                                    '<input class="form-check-input" style="width:15px;height:15px" value="' + item['Cod_Medico'] + '" name="medico_cita" type="radio">' +
                                    '<label class="form-check-label" style="font-size: 20px;"></label>' +
                                    '</div>' +
                                    '</td>' +
                                    '</tr>'
                                );
                            }
                            $("#paso_2").css("display", "none");
                            $("#paso_3").css("display", "block");
                        }
                    
                        
                    } else { // NO SE ENCONTRAROS ESPECIALIDADES
                        Swal.fire({
                            icon: 'warning',
                            title: 'No se encontraron médicos disponibles!',
                            showConfirmButton: true,
                            confirmButtonText: 'Aceptar',
                            confirmButtonColor: '#d42946',
                            timerProgressBar: false,
                        })
                    }
                },
                error: function (jqXHR) { // ERROR AJAX
                    $('#loaderModal').css('display', 'none');
                    console.log('error!');
                    Swal.fire({
                        icon: 'error',
                        title: 'Ha ocurrido un error!',
                        showConfirmButton: true,
                        confirmButtonText: 'Aceptar',
                        confirmButtonColor: '#d42946',
                        timerProgressBar: false,
                    })
                }
            });
        } else { //Error API
            console.log('Error 001');
        }

    } else { // SELECCIONE UNA OPCION
        Swal.fire({
            icon: 'error',
            title: 'Por favor, selecciona una opción',
            showConfirmButton: true,
            confirmButtonText: 'Aceptar',
            confirmButtonColor: '#d42946',
            timerProgressBar: false,
        })
    }

});

btn_sig_paso_auto.addEventListener('click', function () {
    const autorizacion_cita = $('input[name="autorizacion_cita"]:checked').val();
    if (autorizacion_cita != null) { // OPCION SELECCIONADA

        globAutorizacionN = globAuto[autorizacion_cita].N;
        globAutorizacionCodEspecialidad = globAuto[autorizacion_cita].cod_Especialidad;
        globAutorizacionDescEspecialidad = globAuto[autorizacion_cita].Desc_Especialidad;
        globAutorizacionCodProcedimiento = globAuto[autorizacion_cita].cod_procedimiento;
        globAutorizacionNROAUTORIZACION = globAuto[autorizacion_cita].NRO_AUTORIZACION;
        globAutorizacionFechaInicioVigencia = globAuto[autorizacion_cita].fecha_inicio_vigencia;
        globAutorizacionFechaFinVigencia = globAuto[autorizacion_cita].fecha_fin_vigencia;
        globAutorizacionSedeDestino = globAuto[autorizacion_cita].sede_destino;
        globAutorizacionCodEmpresa = globAuto[autorizacion_cita].Cod_Empresa;

        const dataSend = {
            "especialidad": globAutorizacionCodEspecialidad,
            "sede": globAutorizacionSedeDestino
        }

        $.ajax({
            url: '../../age/get/med',
            type: 'GET',
            dataType: 'json',
            data: dataSend,
            beforeSend: function () {
                $('#loaderModal').css('display', 'block');
            },
            success: function (response) {
                $('#loaderModal').css('display', 'none');
                if (response != "1") { // SE ENCONTRAROS MEDICOS
                    var listado3 = $("[name=tbody_medicos]");
                    listado3.empty();
                    globMedicosData = response;
                    for (var i = 0; i < globMedicosData.length; i++) {
                        var item = globMedicosData[i];
                        listado3.append(
                            '<tr>' +
                            '<th scope="row" style="text-align: center">' + item['Nom_Medico'] + '</th>' +
                            '<td style="text-align: center">' +
                            '<div class="form-check">' +
                            '<input class="form-check-input" style="width:15px;height:15px" value="' + item['Cod_Medico'] + '" name="medico_cita" type="radio">' +
                            '<label class="form-check-label" style="font-size: 20px;"></label>' +
                            '</div>' +
                            '</td>' +
                            '</tr>'
                        );
                    }
                    $("#paso_auto").css("display", "none");
                    $("#paso_3").css("display", "block");
                } else { // NO SE ENCONTRAROS ESPECIALIDADES
                    Swal.fire({
                        icon: 'warning',
                        title: 'No se encontraron médicos disponibles!',
                        showConfirmButton: true,
                        confirmButtonText: 'Aceptar',
                        confirmButtonColor: '#d42946',
                        timerProgressBar: false,
                    })
                }
            },
            error: function (jqXHR) { // ERROR AJAX
                $('#loaderModal').css('display', 'none');
                console.log('error!');
                Swal.fire({
                    icon: 'error',
                    title: 'Ha ocurrido un error!',
                    showConfirmButton: true,
                    confirmButtonText: 'Aceptar',
                    confirmButtonColor: '#d42946',
                    timerProgressBar: false,
                })
            }
        });



    } else { // SELECCIONE UNA OPCION
        Swal.fire({
            icon: 'error',
            title: 'Por favor, selecciona una opción',
            showConfirmButton: true,
            confirmButtonText: 'Aceptar',
            confirmButtonColor: '#d42946',
            timerProgressBar: false,
        })
    }
});

btn_sig_paso_3.addEventListener('click', function () {

    const medico_cita = $('input[name="medico_cita"]:checked').val();
    
    if (medico_cita != null) {
        globMedicoSelect = medico_cita;

        globMedicoNombre = globMedicosData.find(medS => medS.Cod_Medico === medico_cita).Nom_Medico;

        var dataSend;

        if (globNeedAuto == "N") {
            dataSend = {
                "medico": globMedicoSelect,
                "especialidad": globCodEspecialidad,
                "sede": globSedeSelect
            }
        } else if (globNeedAuto == "S") {
            dataSend = {
                "medico": globMedicoSelect,
                "especialidad": globAutorizacionCodEspecialidad,
                "sede": globAutorizacionSedeDestino
            }
        }
        
        $.ajax({
            url: '../../age/get/med/age',
            type: 'GET',
            dataType: 'json',
            data: dataSend,
            beforeSend: function () {
                $('#loaderModal').css('display', 'block');
                console.log('a');
            },
            success: function (response) {
                $('#loaderModal').css('display', 'none');
                if (response != "1") { // SE ENCONTRAROS AGENDAS
                    var listado3 = $("[name=tbody_agenda]");
                    listado3.empty();
                    var data = response
                    // Obtener la referencia a la tabla
                    var dataTable = $('#agendaTabla').DataTable();
                    dataTable.destroy();
                    var dataTable = $('#agendaTabla').DataTable({
                        language: {
                            processing: "Procesando...",
                            search: "Buscar:",
                            lengthMenu: "Mostrar _MENU_ elementos",
                            info: "Mostrando desde _START_ al _END_ de _TOTAL_ elementos",
                            infoEmpty: "Mostrando ningún elemento.",
                            infoFiltered: "(filtrado _MAX_ elementos total)",
                            infoPostFix: "",
                            loadingRecords: "Cargando registros...",
                            zeroRecords: "Ningún dato disponible en esta tabla",
                            emptyTable: "No hay datos disponibles en esta tabla",
                            paginate: {
                                first: "Primero",
                                previous: "Anterior",
                                next: "Siguiente",
                                last: "Último"
                            },
                            aria: {
                                sortAscending: ": Activar para ordenar la columna de manera ascendente",
                                sortDescending: ": Activar para ordenar la columna de manera descendente"
                            }
                        }
                    });
                    // Limpiar la tabla antes de agregar nuevos datos
                    dataTable.clear().draw();
                    // Iterar sobre los datos recibidos y agregarlos a la tabla
                    for (var i = 0; i < data.length; i++) {
                        var item = data[i];
                        dataTable.row.add([item.Fecha_Agenda,
                        '<div class="form-check">' +
                        '<input class="form-check-input" style="width:15px;height:15px" value="' + item.Fecha_Agenda + '" name="fechas_cita" type="radio">' +
                        '<label class="form-check-label" style="font-size: 20px;"></label>' +
                        '</div>'
                        ]).draw();
                    }
                    $("#paso_3").css("display", "none");
                    $("#paso_4").css("display", "block");
                } else { // NO SE ENCONTRAROS ESPECIALIDADES
                    Swal.fire({
                        icon: 'warning',
                        title: 'No se encontraron agendas disponibles!',
                        showConfirmButton: true,
                        confirmButtonText: 'Aceptar',
                        confirmButtonColor: '#d42946',
                        timerProgressBar: false,
                    })
                }
            },
            error: function (jqXHR) { // ERROR AJAX
                $('#loaderModal').css('display', 'none');
                console.log('error!');
                Swal.fire({
                    icon: 'error',
                    title: 'Ha ocurrido un error!',
                    showConfirmButton: true,
                    confirmButtonText: 'Aceptar',
                    confirmButtonColor: '#d42946',
                    timerProgressBar: false,
                })
            }
        });

    } else { // NO SELECCIONO UNA OPCION
        Swal.fire({
            icon: 'error',
            title: 'Por favor, selecciona una opción',
            showConfirmButton: true,
            confirmButtonText: 'Aceptar',
            confirmButtonColor: '#d42946',
            timerProgressBar: false,
        })
    }

});

btn_sig_paso_4.addEventListener('click', function () {
    const fechas_cita = $('input[name="fechas_cita"]:checked').val();
    $('.span_fecha_cita').val(fechas_cita);

    if (fechas_cita != null) {
        var seguir = 0;
        globFechaSelect = fechas_cita;
        var dataSend;

        if (globNeedAuto == "S") {
            const fechaSeleccionada = new Date(globFechaSelect);
            const fechaVigenciaAutorizacion = new Date(globAutorizacionFechaFinVigencia);

            if (fechaSeleccionada > fechaVigenciaAutorizacion) {
                Swal.fire({
                    icon: 'warning',
                    title: 'La fecha ' + globFechaSelect + ' es mayor a la vigencia de su autorización ' + globAutorizacionFechaFinVigencia,
                    showConfirmButton: true,
                    confirmButtonText: 'Aceptar',
                    confirmButtonColor: '#d42946',
                    timerProgressBar: false,
                })
                seguir = 1;
            }
        }

        if (seguir == 0) {
            if (globNeedAuto == "N") {
                dataSend = {
                    "medico": globMedicoSelect,
                    "especialidad": globCodEspecialidad,
                    "fechaSelect": globFechaSelect,
                    "sede": globSedeSelect,
                    "codEmpresa": globCodEmpresa
                }
            } else if (globNeedAuto == "S") {
                dataSend = {
                    "medico": globMedicoSelect,
                    "especialidad": globAutorizacionCodEspecialidad,
                    "fechaSelect": globFechaSelect,
                    "sede": globAutorizacionSedeDestino,
                    "codEmpresa": globAutorizacionCodEmpresa
                }
            }
            
            $.ajax({
                url: '../../age/get/age/hor',
                type: 'GET',
                dataType: 'json',
                data: dataSend,
                beforeSend: function () {
                    $('#loaderModal').css('display', 'block');
                },
                success: function (response) {
                    $('#loaderModal').css('display', 'none');
                    if(response.success == "2"){
                        Swal.fire({
                            icon: 'warning',
                            title: response.message,
                            showConfirmButton: true,
                            confirmButtonText: 'Aceptar',
                            confirmButtonColor: '#d42946',
                            timerProgressBar: false,
                        })
                    } else if (response.success == "0") { // SE ENCONTRAROS AGENDAS
                        var listado3 = $("[name=tbody_agenda_horas]");
                        listado3.empty();
                        globHoras = response.data;
                        // Obtener la referencia a la tabla
                        var dataTable = $('#agendaTablaHoras').DataTable();
                        dataTable.destroy();
                        var dataTable = $('#agendaTablaHoras').DataTable({
                            language: {
                                processing: "Procesando...",
                                search: "Buscar:",
                                lengthMenu: "Mostrar _MENU_ elementos",
                                info: "Mostrando desde _START_ al _END_ de _TOTAL_ elementos",
                                infoEmpty: "Mostrando ningún elemento.",
                                infoFiltered: "(filtrado _MAX_ elementos total)",
                                infoPostFix: "",
                                loadingRecords: "Cargando registros...",
                                zeroRecords: "Ningún dato disponible en esta tabla",
                                emptyTable: "No hay datos disponibles en esta tabla",
                                paginate: {
                                    first: "Primero",
                                    previous: "Anterior",
                                    next: "Siguiente",
                                    last: "Último"
                                },
                                aria: {
                                    sortAscending: ": Activar para ordenar la columna de manera ascendente",
                                    sortDescending: ": Activar para ordenar la columna de manera descendente"
                                }
                            }
                        });
                        // Limpiar la tabla antes de agregar nuevos datos
                        dataTable.clear().draw();
                        // Iterar sobre los datos recibidos y agregarlos a la tabla
                        for (var i = 0; i < globHoras.length; i++) {
                            var item = globHoras[i];
                            dataTable.row.add([item.Hora_Inicio + ' - ' + item.Hora_Fin,
                            '<div class="form-check">' +
                            '<input class="form-check-input" style="width:15px;height:15px" value="' + i + '" name="hora_cita" type="radio">' +
                            '<label class="form-check-label" style="font-size: 20px;"></label>' +
                            '</div>'
                            ]).draw();
                        }
                        $("#paso_4").css("display", "none");
                        $("#paso_5").css("display", "block");
                    } else { // NO SE ENCONTRAROS ESPECIALIDADES
                        Swal.fire({
                            icon: 'warning',
                            title: 'No se encontraron horas!',
                            showConfirmButton: true,
                            confirmButtonText: 'Aceptar',
                            confirmButtonColor: '#d42946',
                            timerProgressBar: false,
                        })
                    }
                },
                error: function (jqXHR) { // ERROR AJAX
                    $('#loaderModal').css('display', 'none');
                    Swal.fire({
                        icon: 'error',
                        title: 'Ha ocurrido un error!',
                        showConfirmButton: true,
                        confirmButtonText: 'Aceptar',
                        confirmButtonColor: '#d42946',
                        timerProgressBar: false,
                    })
                }
            });
        }

    } else {
        Swal.fire({
            icon: 'error',
            title: 'Por favor, selecciona una opción',
            showConfirmButton: true,
            confirmButtonText: 'Aceptar',
            confirmButtonColor: '#d42946',
            timerProgressBar: false,
        })
    }
});

btn_sig_paso_5.addEventListener('click', function () {
    const hora_cita = $('input[name="hora_cita"]:checked').val();

    if (hora_cita != null) {
        globHoraInit = globHoras[hora_cita].Hora_Inicio;
        globHoraFinish = globHoras[hora_cita].Hora_Fin;
        globCodConsultorio = globHoras[hora_cita].Cod_Consultorio;
        globCitTime = globHoras[hora_cita].Duracion;

        Swal.fire({
            title: 'Precaución',
            text: 'Su cita se agendara para el día ' + globFechaSelect + ' a las ' + globHoraInit + ' ¿esta seguro?',
            icon: 'info',
            showDenyButton: true,
            confirmButtonText: 'Aceptar',
            denyButtonText: 'Cancelar',
            denyButtonColor: '#d42946',
        }).then((result) => {
            if (result.isConfirmed) {

                var dataSend;

                if (globNeedAuto == "N") {
                    dataSend = {
                        "medico": globMedicoSelect,
                        "medicoName": globMedicoNombre,
                        "especialidad": globCodEspecialidad,
                        "especialidadName": globNomEspecialidad,
                        "fechaSelect": globFechaSelect,
                        "HoraInit": globHoraInit,
                        "HoraFinish": globHoraFinish,
                        "CodConsultorio": globCodConsultorio,
                        "CitTime": globCitTime,
                        "codProcedimiento": globCodCups,
                        "primeraVez": globTipCita,
                        "sede": globSedeSelect,
                        "sedeName": globSedeNombre,
                        "codEmpresa": globCodEmpresa
                    }
                } else if (globNeedAuto == "S") {
                    dataSend = {
                        "medico": globMedicoSelect,
                        "medicoName": globMedicoNombre,
                        "especialidad": globAutorizacionCodEspecialidad,
                        "especialidadName": globNomEspecialidad,
                        "fechaSelect": globFechaSelect,
                        "HoraInit": globHoraInit,
                        "HoraFinish": globHoraFinish,
                        "CodConsultorio": globCodConsultorio,
                        "CitTime": globCitTime,
                        "codProcedimiento": globAutorizacionCodProcedimiento,
                        "autorizacion": globAutorizacionNROAUTORIZACION,
                        "primeraVez": globTipCita,
                        "sede": globAutorizacionSedeDestino,
                        "sedeName": globSedeNombre,
                        "codEmpresa": globAutorizacionCodEmpresa
                    }
                }

                $.ajax({
                    url: '../../age/post/cit',
                    type: 'get',
                    dataType: 'json',
                    data: dataSend,
                    beforeSend: function () {
                        $('#loaderModal').css('display', 'block');
                    },
                    success: function (response) {
                        $('#loaderModal').css('display', 'none');
                        if (response.success == "0") { // SE AGENDO CORRECTAMENTE
                            document.getElementById("messageCita").innerHTML = response.message;
                            $("#paso_5").css("display", "none");
                            $("#paso_6").css("display", "block");
                        } else { // NO SE AGENDO CORRECTAMENTE
                            Swal.fire({
                                icon: 'warning',
                                title: response.message,
                                showConfirmButton: true,
                                confirmButtonText: 'Aceptar',
                                confirmButtonColor: '#d42946',
                                timerProgressBar: false,
                            })
                        }
                    },
                    error: function (jqXHR) { // ERROR AJAX
                        $('#loaderModal').css('display', 'none');
                        console.log('error!');
                        Swal.fire({
                            icon: 'error',
                            title: 'Ha ocurrido un error!',
                            showConfirmButton: true,
                            confirmButtonText: 'Aceptar',
                            confirmButtonColor: '#d42946',
                            timerProgressBar: false,
                        })
                    }
                });

            }
        })


    } else {
        Swal.fire({
            icon: 'error',
            title: 'Por favor, selecciona una opción',
            showConfirmButton: true,
            confirmButtonText: 'Aceptar',
            confirmButtonColor: '#d42946',
            timerProgressBar: false,
        })
    }
});
