<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Http;
use GuzzleHttp\Client;

class MenuController extends Controller
{
    protected $url = "http://wscitas.ocgnlocal.co:8086";

    private function GetToken()
    {
        $token_peticion = Http::get($this->url . '/Token/GetToken?usuario=contac&clave=contac');
        $body_peticion = json_decode($token_peticion->body());
        return $body_peticion->response;
    }

    public function redirectMenu(request $request)
    {
        $token = $this->GetToken();
        $token_peticion = Http::get($this->url . '/Maestros/Motivo_Cancelacion_Det?Token=' . $token);
        $body_peticion = json_decode($token_peticion->body());
        $motivosCancelacion = json_decode($body_peticion->response);
        
        switch ($request->menu_opciones) {
            case '1':
                return view('menu.agendamiento');
            case '2':
                return view('menu.cancelacion', compact('motivosCancelacion'));
            case '3':
                return view('menu.reasignacion', compact('motivosCancelacion'));
            default:
                return redirect()->back();
        }
    }

}
