<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Http;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Mail;

class HomeController extends Controller
{

    public function index(request $request)
    {
        /* Eliminamos todas las variables de session */
        Session::put('is_authenticated', false);
        $request->session()->forget(['typeId', 'Id', 'name', 'firstName', 'tel', 'email', 'firstLastName', 'CodEmpresa', 'CodSede', 'IdOpetador']);

        /* Extraemos el token */
        $token_peticion = Http::get('http://wscitas.ocgnlocal.co:8086/Token/GetToken?usuario=contac&clave=contac');
        $body_peticion = json_decode($token_peticion->body());
        $token = $body_peticion->response;

        /* Extraemos el tipos identificacion */
        $tipos_identificacion_peticion = Http::get('http://wscitas.ocgnlocal.co:8086/Maestros/TipoIdentificacion?Token=' . $token);
        $body_peticion2 = json_decode($tipos_identificacion_peticion->body());
        $tipos_identificacion = json_decode($body_peticion2->response);

        return view('info', compact('tipos_identificacion'));
    }

    public function findUser(request $request)
    {
        /* Extraemos el token */
        $token_peticion = Http::get('http://wscitas.ocgnlocal.co:8086/Token/GetToken?usuario=contac&clave=contac');
        $body_peticion = json_decode($token_peticion->body());
        $token = $body_peticion->response;

        /* Extraemos la informacion del usuario */
        $dataUser = Http::get('http://wscitas.ocgnlocal.co:8086/Usuario/Select?Token=' . $token . '&tipo_ide=' . $request->tipo_documento . '&ide=' . $request->documento);
        $body_peticion2 = json_decode($dataUser->body());
        $dataUser = json_decode($body_peticion2->response);

        if (json_decode($body_peticion2->status) == "0") {

            // if($dataUser[0]->Celular == "" && $dataUser[0]->Correo == ""){
            //     return json_encode(
            //         array(
            //             "status" => "2",
            //             "mensaje" => "Sr(a) ".$dataUser[0]->Nombre_Completo.", usted no cuenta con ningún método de autenticación, favor acercarse a su sede primaria para actualizar datos"
            //         )
            //     );
            // }

            Session::put('is_authenticated', true);
        /* Creamos variables de session con data que podremos usar despues */
            request()->session()->put('typeId', $dataUser[0]->Tipo_ide);
            request()->session()->put('Id', $dataUser[0]->Ide);
            request()->session()->put('firstName', $dataUser[0]->Nom1);
            request()->session()->put('tel', $dataUser[0]->Celular);
            request()->session()->put('email', $dataUser[0]->Correo);
            request()->session()->put('name', $dataUser[0]->Nombre_Completo);
            request()->session()->put('firstLastName', $dataUser[0]->Ape1);
            request()->session()->put('CodEmpresa', $dataUser[0]->Cod_Empresa);
            request()->session()->put('CodSede', $dataUser[0]->Cod_Sede);
            request()->session()->put('firstLastName', $dataUser[0]->Ape1);
            request()->session()->put('IdOpetador', $dataUser[0]->Id_Opetador);
            request()->session()->put('CodContrato', $dataUser[0]->Contrato);
            return json_encode(
                array(
                    "status" => "0",
                    "data" => $dataUser[0]
                )
            );
        } else {
            return json_encode(
                array(
                    "status" => json_decode($body_peticion2->status),
                    "data" => ""
                )
            );
        }
    }

    public function confirmEmail($email)
    {
        // Generar un código de confirmación aleatorio de 5 dígitos
        $codigoConfirmacion = random_int(10000, 99999);

        // try {
        //     Mail::send('email.codigo', compact('codigoConfirmacion'), function ($mail) use ($email) {
        //         $mail->from(env('MAIL_USERNAME'), 'Contacta');
        //         $mail->to($email);
        //         $mail->subject('Código Confirmación');
        //     });
        // } catch (\Exception $e) {
        //     return json_encode(
        //         array(
        //             "success" => "1",
        //             "message" => "ERROR : {$e}"
        //         )
        //     );
        // }

        return json_encode(
            array(
                "success" => "0",
                "codigo" => $codigoConfirmacion
            )
        );

    }

    public function confirmTel($telefono)
    {

        // Generar un código de confirmación aleatorio de 5 dígitos
        $codigoConfirmacion = random_int(10000, 99999);

        return json_encode(
            array(
                "success" => "0",
                "codigo" => $codigoConfirmacion
            )
        );

        // $mensaje = "Tu código de verificación de Autoagendamiento-Organización Clínica General del Norte es: ".$codigoConfirmacion;

        // /* Extraemos la informacion del usuario */
        // $dataSendSMS = Http::get('https://xr622l.api.infobip.com/sms/1/text/query?username=ClinicaApi&password=C0nt4ct4.2023&from=Clinica&to="57"'.$telefono.'&text='.$mensaje);
        // $body_peticion = json_decode($dataSendSMS->body());

        // if(isset($body_peticion->requestError)){
        //     /* dd($body_peticion->requestError); */
        //     return json_encode(
        //         array(
        //             "success" => "1"
        //         )
        //     );
        // }else{
        //     return json_encode(
        //         array(
        //             "success" => "0",
        //             "codigo" => $codigoConfirmacion
        //         )
        //     );
        // }

    }

    public function updatePac(request $request)
    {
        /* Extraemos el token */
        $token_peticion = Http::get('http://wscitas.ocgnlocal.co:8086/Token/GetToken?usuario=contac&clave=contac');
        $body_peticion = json_decode($token_peticion->body());
        $token = $body_peticion->response;

        // Instanciar el cliente de GuzzleHttp y establecer la URL base
        $client = new Client(['base_uri' => 'http://wscitas.ocgnlocal.co:8086']);

        // Datos que deseas enviar en el cuerpo de la solicitud (en formato JSON)
        $data = [
            "token" => $token,
            "tipo_ide" => $request->tip_document,
            "ide" => $request->document,
            "telefono" => $request->numero_tel,
            "correo" => $request->correo
        ];

        // Opciones para la solicitud (método, cuerpo, encabezados, etc.)
        $options = [
            'headers' => [
                'Accept' => 'application/json',
            ],
            'json' => $data, // Envía el cuerpo en formato JSON
        ];

        // Endpoint para la solicitud (agrega el endpoint específico que necesitas consultar)
        $endpoint = '/Usuario/Update';

        try {
            // Realizar la solicitud POST con GuzzleHttp
            $response = $client->post($endpoint, $options);

            // Obtener el contenido de la respuesta (generalmente será JSON, pero podría ser otro formato)
            $responseData = $response->getBody()->getContents();

            // Procesar $responseData según sea necesario...

            // Ejemplo: Decodificar JSON a un arreglo asociativo
            $responseDataArray = json_decode($responseData, true);

            if ($responseDataArray['status'] == "0") {
                if ($request->sendby == "1") {
                    return json_encode(
                        array(
                            "success" => 0,
                            "data" => $request->numero_tel,
                        )
                    );
                } else if ($request->sendby == "2") {
                    return json_encode(
                        array(
                            "success" => 0,
                            "data" => $request->correo,
                        )
                    );
                }
            } else {
                return 1;
            }
        } catch (\Exception $e) {
            return 1;
        }

    }

}
