<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Http;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Mail;

class CancelarController extends Controller
{
    protected $url = "http://wscitas.ocgnlocal.co:8086";

    private function GetToken()
    {
        $token_peticion = Http::get($this->url . '/Token/GetToken?usuario=contac&clave=contac');
        $body_peticion = json_decode($token_peticion->body());
        return $body_peticion->response;
    }

    public function GetCit(request $request)
    {
        $token = $this->GetToken();

        $Citas = Http::get($this->url . '/Citas/Historico_Cita?Token=' . $token . '&Empresa=' . Session::get('CodEmpresa') . '&Ide=' . Session::get('Id') . '&Tipo_ide=' . Session::get('typeId') . '&Estado=R');
        $body_peticion3 = json_decode($Citas->body());
        $Citas = json_decode($body_peticion3->response);

        if (json_decode($body_peticion3->status) == "0") {
            return $Citas;
        } else {
            return json_decode($body_peticion3->status);
        }
    }

    public function PostCancel(request $request)
    {
        $token = $this->GetToken();

        $dataConsecutivo = Http::get($this->url . '/Citas/Consecutivo?Token=' . $token . '&Cod_Empresa=' . $request->CodEmpresa . '&Cod_Sede=' . $request->CodSede . '&Cod_Fuente=CCI');
        $body_peticion = json_decode($dataConsecutivo->body());
        $dataConsecutivo = json_decode($body_peticion->response);
        $Consecutivo = $dataConsecutivo[0]->n_cita;

        // Se inicializa instancia cliente
        $client = new \GuzzleHttp\Client();

        //Se crea el body
        $body = [
            "token" => $token,
            "empresa" => $request->CodEmpresa,
            "sede" => $request->CodSede,
            "n_Cita" => $request->NCita,
            "usuAddMod" => "contacPag",
            "motivo_Enc" => "2",
            "observacion" => "cancelado por Pagina",
            "motivo_Det" => $request->MotivoCancelacion,
            "tipo_Identificacion" => Session::get('typeId'),
            "identificacion" => Session::get('Id'),
            "nombre_Cancela" => Session::get('name'),
            "parentesco" => "0",
            "consecutivo" => $Consecutivo
        ];

        // Se consume la api
        $response = $client->request('POST', $this->url . '/Citas/Cancelar_Cita', [
            'headers' => [
                'Content-Type' => 'application/json'
            ],
            'body' => json_encode($body),
        ]);

        //Se obtiene respuesta
        $body = json_decode($response->getBody()->getContents());

        if ($body->status == "0") {

            $mensaje = "Sr./a " . Session::get('name') . ", su cita con el médico ".$request->DescMedico." para el día ".$request->FechaCita." a las ".$request->HoraCita." para la especialidad ".$request->DescEspecialidad.", fue cancelada con éxito.";

            $especialidadName = $request->DescEspecialidad;
            $sedeName = $request->DescSede;
            $fechaSelect = $request->FechaCita;
            $HoraInit = $request->HoraCita;
            $medicoName = $request->DescMedico;

            try {
                /* Extraemos la informacion del usuario */
                $dataSendSMS = Http::get('https://xr622l.api.infobip.com/sms/1/text/query?username=ClinicaApi&password=C0nt4ct4.2023&from=Clinica&to="57"'.Session::get('tel').'&text='.$mensaje);
                $body_peticion = json_decode($dataSendSMS->body());
            } catch (\Throwable $th) {
            }

            try {
                Mail::send('email.cancelacion', compact('especialidadName', 'sedeName', 'fechaSelect', 'HoraInit', 'medicoName'), function ($mail) {
                    $mail->from(env('MAIL_USERNAME'), 'Contacta');
                    $mail->to(Session::get('email'));
                    $mail->subject('Cancelación de Cita');
                });
            } catch (\Throwable $th) {
            }

            return json_encode(
                array(
                    "success" => "0",
                    "message" => 'Sr/a ' . Session::get('name') . ' su cita de ' . $request->DescEspecialidad . '
                     del día ' . $request->FechaCita . ' con el médico ' . $request->DescMedico . ' fue cancelada con éxito'
                )
            );
        } else {
            return json_encode(
                array(
                    "success" => "1",
                    "message" => $body->response
                )
            );
        }

    }

}
