<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Http;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Mail;

class AgendamientoController extends Controller
{

    protected $url = "http://wscitas.ocgnlocal.co:8086";

    private function GetToken()
    {
        $token_peticion = Http::get($this->url . '/Token/GetToken?usuario=contac&clave=contac');
        $body_peticion = json_decode($token_peticion->body());
        return $body_peticion->response;
    }

    public function GetSedes(request $request)
    {
        $token = $this->GetToken();
        $token_peticion = Http::get($this->url . '/Maestros/Sede?Token=' . $token);
        $body_peticion = json_decode($token_peticion->body());
        $sedes = json_decode($body_peticion->response);

        if (json_decode($body_peticion->status) == "0") {
            return $sedes;
        } else {
            return json_decode($body_peticion->status);
        }
    }

    public function GetAutorizaciones(request $request)
    {
        $token = $this->GetToken();
        /* Extraemos las autorizaciones del paciente */
        $AutoPac = Http::get($this->url . '/Citas/Autorizaciones?Token=' . $token . '&Ide=' . Session::get('Id') . '&Tipo_ide=' . Session::get('typeId') . '&Cod_Especialidad=' . $request->especialidad);
        $body_peticion2 = json_decode($AutoPac->body());
        $AutoPac = json_decode($body_peticion2->response);
        if (json_decode($body_peticion2->status) == "0") {
            return $AutoPac;
        } else {
            return json_decode($body_peticion2->status);
        }
    }

    public function GetEspecialidades(request $request)
    {
        $token = $this->GetToken();
    
        if ($request->sede == null) {
            $CodSede = Session::get('CodSede');
        } else {
            $CodSede = $request->sede;
        }
    
        /* Las especialidades */
        $Especialidades = Http::get($this->url . '/Maestros/Especialidad?Token=' . $token . '&Cod_sede=' . $CodSede);
        $body_peticion2 = json_decode($Especialidades->body());
        $Especialidades = json_decode($body_peticion2->response);
        
        if (json_decode($body_peticion2->status) == "0") {
            return $Especialidades;
        } else {
            return json_decode($body_peticion2->status);
        }

    }

    public function GetMedicos(request $request)
    {
        $token = $this->GetToken();

        if ($request->sede == null) {
            $CodSede = Session::get('CodSede');
        } else {
            $CodSede = $request->sede;
        }

        /* Extraemos los medicos */
        $Medicos = Http::get($this->url . '/Maestros/Medico?Token=' . $token . '&Cod_sede=' . $CodSede . '&Cod_Especialidad=' . $request->especialidad);
        $body_peticion3 = json_decode($Medicos->body());
        $Medicos = json_decode($body_peticion3->response);
        
        if (json_decode($body_peticion3->status) == "0") {
            return $Medicos;
        } else {
            return json_decode($body_peticion3->status);
        }
    }

    public function GetAgenda(request $request)
    {
        $token = $this->GetToken();

        if ($request->sede == null) {
            $CodSede = Session::get('CodSede');
        } else {
            $CodSede = $request->sede;
        }

        /* Buscamos las agendas disponibles */
        $dataAgenda = Http::get($this->url . '/Citas/Agendas?Token=' . $token . '&Cod_Sede=' . $CodSede . '&Cod_Especialidad=' . $request->especialidad . '&Cod_Medico=' . $request->medico."&Pag=0&Rows=1000");
        $body_peticion3 = json_decode($dataAgenda->body());
        $dataAgenda = json_decode($body_peticion3->response);
        
        if (json_decode($body_peticion3->status) == "0") {
            return $dataAgenda;
        } else {
            return json_decode($body_peticion3->status);
        }

        //
    }

    public function GetHoras(request $request)
    {
        $token = $this->GetToken();

        if ($request->sede == null) {
            $CodSede = Session::get('CodSede');
        } else {
            $CodSede = $request->sede;
        }
        
        /* Extraemos las horas de ese dia en agenda */
        $dataHoras = Http::get($this->url . '/Citas/Hora?Token=' . $token . '&Cod_Sede=' . $CodSede .'&Cod_Empresa='.$request->codEmpresa.'&Cod_Especialidad=' . $request->especialidad . '&Cod_Medico=' . $request->medico . '&fecha_cita=' . $request->fechaSelect . '&Ide=' . Session::get('Id') . '&Tipo_ide=' . Session::get('typeId') . "&Pag=0&Rows=1000");
        $body_peticion2 = json_decode($dataHoras->body());
        $dataHoras = json_decode($body_peticion2->response);
        
        if (json_decode($body_peticion2->status) == "0") {
            return json_encode(
                array(
                    "success" => "0",
                    "data" => $dataHoras
                )
            );
        } else {
            if(json_decode($body_peticion2->status) == "2"){
                return json_encode(
                    array(
                        "success" => "2",
                        "message" => $body_peticion2->mensaje
                    )
                );
            }else{
                return json_decode($body_peticion2->status);
            }
        }

    }

    public function PostCita(request $request)
    {
        $token = $this->GetToken();

        $nowDate = date("Y-m-j");
        if ($request->sede == null) {
            $CodSede = Session::get('CodSede');
        } else {
            $CodSede = $request->sede;
        }

        if ($request->codEmpresa == null) {
            $CodEmpresa = Session::get('CodEmpresa');
        } else {
            $CodEmpresa = $request->codEmpresa;
        }

        if ($request->autorizacion == null) {
            $autorizacion = "";
        } else {
            $autorizacion = $request->autorizacion;
        }

        $dataConsecutivo = Http::get($this->url . '/Citas/Consecutivo?Token=' . $token . '&Cod_Empresa=' . $CodEmpresa . '&Cod_Sede=' . $CodSede . '&Cod_Fuente=CIT');
        $body_peticion = json_decode($dataConsecutivo->body());
        $dataConsecutivo = json_decode($body_peticion->response);
        if($body_peticion->status == "0"){
            $numberCita = $dataConsecutivo[0]->n_cita;
        }else{
            return json_encode(
                array(
                    "success" => "1",
                    "message" => $body_peticion->response
                )
            );
        }
        
        
        // Se inicializa instancia cliente
        $client = new \GuzzleHttp\Client();

        //Se crea el body
        $body = [
            "tipo_Identificacion" => Session::get('typeId'),
            "identificacion" => Session::get('Id'),
            "contrato" => Session::get('CodContrato'),
            "token" => $token,
            "empresa" => $CodEmpresa,
            "sede" => $CodSede,
            "n_Cita" => $numberCita,
            "tipo_de_Cita" => "E",//pred
            "fecha_Cita" => $request->fechaSelect,
            "fecha_Solicitud" => $nowDate,
            "consultorio" => $request->CodConsultorio,
            "hota_Cita" => $request->HoraInit,
            "cod_procedimiento" => $request->codProcedimiento,
            "clase_Procedimiento" => "1",//pred
            "duracion" => $request->CitTime,
            "usuAddMod" => "contacPag",//pred
            "primera_Vez" => $request->primeraVez,
            "tipo_Cita" => "I",//pred
            "cita_PyP" => "",//pred
            "clase_Cita_Medica" => "CO",//pred
            "autorizacion" => $autorizacion,
            "cod_Medico" => $request->medico,
            "cod_Especialidad" => $request->especialidad,
            "tipo_Medico" => "",//pred
            "origen_Historia" => "HC",//pred
            "tipo_Solicitud" => "P",//pred
            "cantidad_Paciente" => "1",//pred
            "modalidad" => "P" //pred
        ];

        // Se consume la api
        $response = $client->request('POST', $this->url . '/Citas/Insert', [
            'headers' => [
                'Content-Type' => 'application/json'
            ],
            'body' => json_encode($body),
        ]);

        //Se obtiene respuesta
        $body = json_decode($response->getBody()->getContents());

        if ($body->status == "0") {

            $mensaje = 'Sr/a ' . Session::get('name') . ' su cita de '.$request->especialidadName.' fue agendada con éxito en la sede '.$request->sedeName.' el día ' . $request->fechaSelect . ' a las ' . $request->HoraInit . '
            con el médico ' . $request->medicoName . ', por favor llegar 15 minutos antes';

            $especialidadName = $request->especialidadName;
            $sedeName = $request->sedeName;
            $fechaSelect = $request->fechaSelect;
            $HoraInit = $request->HoraInit;
            $medicoName = $request->medicoName;

            try {
                /* Extraemos la informacion del usuario */
                $dataSendSMS = Http::get('https://xr622l.api.infobip.com/sms/1/text/query?username=ClinicaApi&password=C0nt4ct4.2023&from=Clinica&to="57"'.Session::get('tel').'&text='.$mensaje);
                $body_peticion = json_decode($dataSendSMS->body());
            } catch (\Throwable $th) {
            }

            try {
                Mail::send('email.agendamiento', compact('especialidadName', 'sedeName', 'fechaSelect', 'HoraInit', 'medicoName'), function ($mail) {
                    $mail->from(env('MAIL_USERNAME'), 'Contacta');
                    $mail->to(Session::get('email'));
                    $mail->subject('Confirmación Agendamiento');
                });
            } catch (\Throwable $th) {
            }

            return json_encode(
                array(
                    "success" => "0",
                    "message" => $mensaje
                )
            );
        } else {
            return json_encode(
                array(
                    "success" => "1",
                    "message" => $body->response
                )
            );
        }

    }

}
