const btn_sig_paso_1 = document.getElementById('btn_sig_paso_1');
const btn_sig_paso_2 = document.getElementById('btn_sig_paso_2');
const btn_sig_paso_3 = document.getElementById('btn_sig_paso_3');
const btn_sig_paso_4 = document.getElementById('btn_sig_paso_4');
const btn_sig_paso_5 = document.getElementById('btn_sig_paso_5');
const btn_sig_paso_6 = document.getElementById('btn_sig_paso_6');
const btn_sig_paso_7 = document.getElementById('btn_sig_paso_7');

/* VAR PROPIAS */
var globCitas;
var globCitaSelect;
var globMotivoCancelacion;
var globMedicoSelect;
var globFechaSelect;
var globHoraInit;
var globHoraFinish;
var globCodConsultorio;
var globCitTime;

/* VAR API HISCLI */
var globCodEmpresa;
var globDescEmpresa;
var globCodSede;
var globDescSede;
var globNCita;
var globTipoIdentificacion;
var globIdentificacion;
var globCodContrato;
var globDescContrato;
var globCodEspecialidad;
var globDescEspecialidad;
var globCodMedico;
var globDescMedico;
var globFechaCita;
var globHoraCita;
var globEstadoCita;
var globTipocita;
var globAutorizacion;

const btnsAntPaso = $(".btn_ant_paso");

btnsAntPaso.on("click", function () {
    const pasoAnterior = parseInt($(this).data("paso"));
    $(`#paso_${pasoAnterior + 1}`).css("display", "none");
    $(`#paso_${pasoAnterior}`).css("display", "block");
});

/* CANCELAR */

window.addEventListener('load', function () {

    $.ajax({
        url: '../../can/get/cit',
        type: 'GET',
        dataType: 'json',
        beforeSend: function () {
            $('#loaderModal').css('display', 'block');
        },
        success: function (response) {
            $('#loaderModal').css('display', 'none');
            if (response != "1") { // SE ENCONTRAROS MEDICOS
                var listado3 = $("[name=tbodyCitas]");
                listado3.empty();
                globCitas = response;
                var dataTable = $('#agendaTablaCitas').DataTable();
                dataTable.destroy();
                var dataTable = $('#agendaTablaCitas').DataTable({
                    language: {
                        processing: "Procesando...",
                        search: "Buscar:",
                        lengthMenu: "Mostrar _MENU_ elementos",
                        info: "Mostrando desde _START_ al _END_ de _TOTAL_ elementos",
                        infoEmpty: "Mostrando ningún elemento.",
                        infoFiltered: "(filtrado _MAX_ elementos total)",
                        infoPostFix: "",
                        loadingRecords: "Cargando registros...",
                        zeroRecords: "Ningún dato disponible en esta tabla",
                        emptyTable: "No hay datos disponibles en esta tabla",
                        paginate: {
                            first: "Primero",
                            previous: "Anterior",
                            next: "Siguiente",
                            last: "Último"
                        },
                        aria: {
                            sortAscending: ": Activar para ordenar la columna de manera ascendente",
                            sortDescending: ": Activar para ordenar la columna de manera descendente"
                        }
                    }
                });
                dataTable.clear().draw();
                for (var i = 0; i < globCitas.length; i++) {
                    var item = globCitas[i];
                    dataTable.row.add([
                        item.Desc_Medico,
                        item.Desc_Especialidad,
                        item.Desc_Sede,
                        item.Fecha_Cita + ' ' + item.Hora_Cita,
                        '<div class="form-check">' +
                        '<input class="form-check-input" style="width:15px;height:15px" value="' + i + '" name="cita_cancelar" type="radio">' +
                        '<label class="form-check-label" style="font-size: 20px;"></label>' +
                        '</div>'
                    ]).draw();
                }
            } else { // NO SE ENCONTRAROS ESPECIALIDADES
                Swal.fire({
                    icon: 'warning',
                    title: 'No se encontraron citas reservadas!',
                    showConfirmButton: true,
                    confirmButtonText: 'Aceptar',
                    confirmButtonColor: '#d42946',
                    timerProgressBar: false,
                })
            }
        },
        error: function (jqXHR) { // ERROR AJAX
            $('#loaderModal').css('display', 'none');
            console.log('error!');
            Swal.fire({
                timer: 4000,
                icon: 'error',
                title: 'Ha ocurrido un error!',
                showConfirmButton: true,
                confirmButtonText: 'Aceptar',
                confirmButtonColor: '#d42946',
                timerProgressBar: false,
            })
        }
    });

});

btn_sig_paso_1.addEventListener('click', function () {
    const cita_cancelar = $('input[name="cita_cancelar"]:checked').val();
    if (cita_cancelar != null) {
        globCitaSelect = cita_cancelar;

        globCodEmpresa = globCitas[cita_cancelar].Cod_Empresa;
        globDescEmpresa = globCitas[cita_cancelar].Desc_Empresa;
        globCodSede = globCitas[cita_cancelar].Cod_Sede;
        globDescSede = globCitas[cita_cancelar].Desc_Sede;
        globNCita = globCitas[cita_cancelar].N_Cita;
        globTipoIdentificacion = globCitas[cita_cancelar].Tipo_Identificacion;
        globIdentificacion = globCitas[cita_cancelar].Identificacion;
        globCodContrato = globCitas[cita_cancelar].Cod_Contrato;
        globDescContrato = globCitas[cita_cancelar].Desc_Contrato;
        globCodEspecialidad = globCitas[cita_cancelar].Cod_Especialidad;
        globDescEspecialidad = globCitas[cita_cancelar].Desc_Especialidad;
        globCodMedico = globCitas[cita_cancelar].Cod_Medico;
        globDescMedico = globCitas[cita_cancelar].Desc_Medico;
        globFechaCita = globCitas[cita_cancelar].Fecha_Cita;
        globHoraCita = globCitas[cita_cancelar].Hora_Cita;
        globEstadoCita = globCitas[cita_cancelar].Estado_Cita;
        globCodProcedimiento = globCitas[cita_cancelar].Cod_procedimiento;
        globTipocita = globCitas[cita_cancelar].Tipo_cita;
        globAutorizacion = globCitas[cita_cancelar].Autorizacion;

        $("#paso_1").css("display", "none");
        $("#paso_2").css("display", "block");
    } else {
        Swal.fire({
            icon: 'error',
            title: 'Por favor, selecciona una cita',
            showConfirmButton: true,
            confirmButtonText: 'Aceptar',
            confirmButtonColor: '#d42946',
            timerProgressBar: false,
        })
    }
});

btn_sig_paso_2.addEventListener('click', function () {
    const motivo_cancelacion = $('input[name="motivo_cancelacion"]:checked').val();

    if (motivo_cancelacion != null) {

        globMotivoCancelacion = motivo_cancelacion;

        document.getElementById("spanMessageCancelar").innerHTML = globDescEspecialidad.toLowerCase() + " " + globFechaCita.toLowerCase() + " a las " + globHoraCita + " con el médico " + globDescMedico;

        $("#paso_2").css("display", "none");
        $("#paso_3").css("display", "block");
    } else {
        Swal.fire({
            icon: 'error',
            title: 'Por favor, selecciona una opción',
            showConfirmButton: true,
            confirmButtonText: 'Aceptar',
            confirmButtonColor: '#d42946',
            timerProgressBar: false,
        })
    }
});

btn_sig_paso_3.addEventListener('click', function () {
    const confirmacion_cancelacion = $('input[name="confirmacion_cancelacion"]:checked').val();

    if (confirmacion_cancelacion == "1") {


        // REASIGNAR MEDICO INICIO
        const dataSend3 = {
            "especialidad": globCodEspecialidad,
            "sede": globCodSede
        }

        $.ajax({
            url: '../../age/get/med',
            type: 'GET',
            dataType: 'json',
            data: dataSend3,
            beforeSend: function () {
                $('#loaderModal').css('display', 'block');
            },
            success: function (response) {
                $('#loaderModal').css('display', 'none');
                if (response != "1") { // SE ENCONTRAROS MEDICOS
                    var listado3 = $("[name=tbody_medicos]");
                    listado3.empty();
                    var data = response
                    for (var i = 0; i < data.length; i++) {
                        var item = data[i];
                        listado3.append(
                            '<tr>' +
                            '<th scope="row" style="text-align: center">' + item['Nom_Medico'] + '</th>' +
                            '<td style="text-align: center">' +
                            '<div class="form-check">' +
                            '<input class="form-check-input" style="width:15px;height:15px" value="' + item['Cod_Medico'] + '" name="medico_cita" type="radio">' +
                            '<label class="form-check-label" style="font-size: 20px;"></label>' +
                            '</div>' +
                            '</td>' +
                            '</tr>'
                        );
                    }
                    $("#paso_3").css("display", "none");
                    $("#paso_5").css("display", "block");
                } else { // NO SE ENCONTRAROS ESPECIALIDADES
                    Swal.fire({
                        icon: 'warning',
                        title: 'No se encontraron médicos disponibles!',
                        showConfirmButton: true,
                        confirmButtonText: 'Aceptar',
                        confirmButtonColor: '#d42946',
                        timerProgressBar: false,
                    })
                }
            },
            error: function (jqXHR) { // ERROR AJAX
                $('#loaderModal').css('display', 'none');
                console.log('error!');
                Swal.fire({
                    icon: 'error',
                    title: 'Ha ocurrido un error!',
                    showConfirmButton: true,
                    confirmButtonText: 'Aceptar',
                    confirmButtonColor: '#d42946',
                    timerProgressBar: false,
                })
            }
        });
        // REASIGNAR MEDICO FIN

    } else if (confirmacion_cancelacion == "0") {
        window.location.href = "/m";
    } else {
        Swal.fire({
            icon: 'error',
            title: 'Por favor, selecciona una opción',
            showConfirmButton: true,
            confirmButtonText: 'Aceptar',
            confirmButtonColor: '#d42946',
            timerProgressBar: false,
        })
    }
});

/* REASIGNAR */

btn_sig_paso_4.addEventListener('click', function () {
    const dataSend2 = {
        "especialidad": globCodEspecialidad,
        "sede": globCodSede
    }

    $.ajax({
        url: '../../age/get/med',
        type: 'GET',
        dataType: 'json',
        data: dataSend2,
        beforeSend: function () {
            $('#loaderModal').css('display', 'block');
        },
        success: function (response) {
            $('#loaderModal').css('display', 'none');
            if (response != "1") { // SE ENCONTRAROS MEDICOS
                var listado3 = $("[name=tbody_medicos]");
                listado3.empty();
                var data = response
                for (var i = 0; i < data.length; i++) {
                    var item = data[i];
                    listado3.append(
                        '<tr>' +
                        '<th scope="row" style="text-align: center">' + item['Nom_Medico'] + '</th>' +
                        '<td style="text-align: center">' +
                        '<div class="form-check">' +
                        '<input class="form-check-input" style="width:15px;height:15px" value="' + item['Cod_Medico'] + '" name="medico_cita" type="radio">' +
                        '<label class="form-check-label" style="font-size: 20px;"></label>' +
                        '</div>' +
                        '</td>' +
                        '</tr>'
                    );
                }
                $("#paso_4").css("display", "none");
                $("#paso_5").css("display", "block");
            } else { // NO SE ENCONTRAROS ESPECIALIDADES
                Swal.fire({
                    icon: 'warning',
                    title: 'No se encontraron médicos disponibles!',
                    showConfirmButton: true,
                    confirmButtonText: 'Aceptar',
                    confirmButtonColor: '#d42946',
                    timerProgressBar: false,
                })
            }
        },
        error: function (jqXHR) { // ERROR AJAX
            $('#loaderModal').css('display', 'none');
            console.log('error!');
            Swal.fire({
                timer: 4000,
                icon: 'error',
                title: 'Ha ocurrido un error!',
                showConfirmButton: true,
                confirmButtonText: 'Aceptar',
                confirmButtonColor: '#d42946',
                timerProgressBar: false,
            })
        }
    });
});

btn_sig_paso_5.addEventListener('click', function () {
    const medico_cita = $('input[name="medico_cita"]:checked').val();
    if (medico_cita != null) {
        globMedicoSelect = medico_cita;

        const dataSend2 = {
            "medico": globMedicoSelect,
            "especialidad": globCodEspecialidad,
            "sede": globCodSede
        }

        $.ajax({
            url: '../../age/get/med/age',
            type: 'GET',
            dataType: 'json',
            data: dataSend2,
            beforeSend: function () {
                $('#loaderModal').css('display', 'block');
            },
            success: function (response) {
                $('#loaderModal').css('display', 'none');
                if (response != "1") { // SE ENCONTRAROS AGENDAS
                    var listado3 = $("[name=tbody_agenda]");
                    listado3.empty();
                    var data = response
                    // Obtener la referencia a la tabla
                    var dataTable = $('#agendaTabla').DataTable();
                    dataTable.destroy();
                    var dataTable = $('#agendaTabla').DataTable({
                        language: {
                            processing: "Procesando...",
                            search: "Buscar:",
                            lengthMenu: "Mostrar _MENU_ elementos",
                            info: "Mostrando desde _START_ al _END_ de _TOTAL_ elementos",
                            infoEmpty: "Mostrando ningún elemento.",
                            infoFiltered: "(filtrado _MAX_ elementos total)",
                            infoPostFix: "",
                            loadingRecords: "Cargando registros...",
                            zeroRecords: "Ningún dato disponible en esta tabla",
                            emptyTable: "No hay datos disponibles en esta tabla",
                            paginate: {
                                first: "Primero",
                                previous: "Anterior",
                                next: "Siguiente",
                                last: "Último"
                            },
                            aria: {
                                sortAscending: ": Activar para ordenar la columna de manera ascendente",
                                sortDescending: ": Activar para ordenar la columna de manera descendente"
                            }
                        }
                    });
                    // Limpiar la tabla antes de agregar nuevos datos
                    dataTable.clear().draw();
                    // Iterar sobre los datos recibidos y agregarlos a la tabla
                    for (var i = 0; i < data.length; i++) {
                        var item = data[i];
                        dataTable.row.add([item.Fecha_Agenda,
                        '<div class="form-check">' +
                        '<input class="form-check-input" style="width:15px;height:15px" value="' + item.Fecha_Agenda + '" name="fechas_cita" type="radio">' +
                        '<label class="form-check-label" style="font-size: 20px;"></label>' +
                        '</div>'
                        ]).draw();
                    }
                    $("#paso_5").css("display", "none");
                    $("#paso_6").css("display", "block");
                } else { // NO SE ENCONTRAROS ESPECIALIDADES
                    Swal.fire({
                        icon: 'warning',
                        title: 'No se encontraron médicos disponibles!',
                        showConfirmButton: true,
                        confirmButtonText: 'Aceptar',
                        confirmButtonColor: '#d42946',
                        timerProgressBar: false,
                    })
                }
            },
            error: function (jqXHR) { // ERROR AJAX
                $('#loaderModal').css('display', 'none');
                console.log('error!');
                Swal.fire({
                    icon: 'error',
                    title: 'Ha ocurrido un error!',
                    showConfirmButton: true,
                    confirmButtonText: 'Aceptar',
                    confirmButtonColor: '#d42946',
                    timerProgressBar: false,
                })
            }
        });

    } else { // NO SELECCIONO UNA OPCION
        Swal.fire({
            icon: 'error',
            title: 'Por favor, selecciona una opción',
            showConfirmButton: true,
            confirmButtonText: 'Aceptar',
            confirmButtonColor: '#d42946',
            timerProgressBar: false,
        })
    }

});

btn_sig_paso_6.addEventListener('click', function () {
    const fechas_cita = $('input[name="fechas_cita"]:checked').val();

    if (fechas_cita != null) {

        globFechaSelect = fechas_cita;

        const dataSend2 = {
            "medico": globMedicoSelect,
            "especialidad": globCodEspecialidad,
            "fechaSelect": globFechaSelect,
            "sede": globCodSede
        }

        $.ajax({
            url: '../../age/get/age/hor',
            type: 'GET',
            dataType: 'json',
            data: dataSend2,
            beforeSend: function () {
                $('#loaderModal').css('display', 'block');
            },
            success: function (response) {
                $('#loaderModal').css('display', 'none');
                if (response != "1") { // SE ENCONTRAROS AGENDAS
                    var listado3 = $("[name=tbody_agenda_horas]");
                    listado3.empty();
                    globHoras = response
                    // Obtener la referencia a la tabla
                    var dataTable = $('#agendaTablaHoras').DataTable();
                    dataTable.destroy();
                    var dataTable = $('#agendaTablaHoras').DataTable({
                        language: {
                            processing: "Procesando...",
                            search: "Buscar:",
                            lengthMenu: "Mostrar _MENU_ elementos",
                            info: "Mostrando desde _START_ al _END_ de _TOTAL_ elementos",
                            infoEmpty: "Mostrando ningún elemento.",
                            infoFiltered: "(filtrado _MAX_ elementos total)",
                            infoPostFix: "",
                            loadingRecords: "Cargando registros...",
                            zeroRecords: "Ningún dato disponible en esta tabla",
                            emptyTable: "No hay datos disponibles en esta tabla",
                            paginate: {
                                first: "Primero",
                                previous: "Anterior",
                                next: "Siguiente",
                                last: "Último"
                            },
                            aria: {
                                sortAscending: ": Activar para ordenar la columna de manera ascendente",
                                sortDescending: ": Activar para ordenar la columna de manera descendente"
                            }
                        }
                    });
                    // Limpiar la tabla antes de agregar nuevos datos
                    dataTable.clear().draw();
                    // Iterar sobre los datos recibidos y agregarlos a la tabla
                    for (var i = 0; i < globHoras.length; i++) {
                        var item = globHoras[i];
                        dataTable.row.add([item.Hora_Inicio + ' - ' + item.Hora_Fin,
                        '<div class="form-check">' +
                        '<input class="form-check-input" style="width:15px;height:15px" value="' + i + '" name="hora_cita" type="radio">' +
                        '<label class="form-check-label" style="font-size: 20px;"></label>' +
                        '</div>'
                        ]).draw();
                    }
                    $("#paso_6").css("display", "none");
                    $("#paso_7").css("display", "block");
                } else { // NO SE ENCONTRAROS ESPECIALIDADES
                    Swal.fire({
                        icon: 'warning',
                        title: 'Ha ocurrido un error!',
                        showConfirmButton: true,
                        confirmButtonText: 'Aceptar',
                        confirmButtonColor: '#d42946',
                        timerProgressBar: false,
                    })
                }
            },
            error: function (jqXHR) { // ERROR AJAX
                $('#loaderModal').css('display', 'none');
                console.log('error!');
                Swal.fire({
                    icon: 'error',
                    title: 'Ha ocurrido un error!',
                    showConfirmButton: true,
                    confirmButtonText: 'Aceptar',
                    confirmButtonColor: '#d42946',
                    timerProgressBar: false,
                })
            }
        });

    } else {
        Swal.fire({
            icon: 'error',
            title: 'Por favor, selecciona una opción',
            showConfirmButton: true,
            confirmButtonText: 'Aceptar',
            confirmButtonColor: '#d42946',
            timerProgressBar: false,
        })
    }

});

btn_sig_paso_7.addEventListener('click', function () {
    const hora_cita = $('input[name="hora_cita"]:checked').val();

    if (hora_cita != null) {
        globHoraInit = globHoras[hora_cita].Hora_Inicio;
        globHoraFinish = globHoras[hora_cita].Hora_Fin;
        globCodConsultorio = globHoras[hora_cita].Cod_Consultorio;
        globCitTime = globHoras[hora_cita].Duracion;

        Swal.fire({
            title: 'Precaución',
            text: 'Su cita se agendara para el día ' + globFechaSelect + ' a las ' + globHoraInit + ' ¿esta seguro?',
            icon: 'info',
            showDenyButton: true,
            confirmButtonText: 'Aceptar',
            denyButtonText: 'Cancelar',
            denyButtonColor: '#d42946',
        }).then((result) => {
            if (result.isConfirmed) {

                var tpcita;
                if (globTipocita == "Primera Vez") {
                    tpcita = "S";
                } else {
                    tpcita = "N";
                }

                const sendData = {
                    "CodEmpresa": globCodEmpresa,
                    "DescEmpresa": globDescEmpresa,
                    "CodSede": globCodSede,
                    "DescSede": globDescSede,
                    "NCita": globNCita,
                    "TipoIdentificacion": globTipoIdentificacion,
                    "Identificacion": globIdentificacion,
                    "CodContrato": globCodContrato,
                    "DescContrato": globDescContrato,
                    "CodEspecialidad": globCodEspecialidad,
                    "DescEspecialidad": globDescEspecialidad,
                    "CodMedico": globCodMedico,
                    "DescMedico": globDescMedico,
                    "FechaCita": globFechaCita,
                    "HoraCita": globHoraCita,
                    "EstadoCita": globEstadoCita,
                    "Tipocita": globTipocita,
                    "MotivoCancelacion": globMotivoCancelacion
                };

                $.ajax({
                    url: '../../can/post',
                    type: 'GET',
                    dataType: 'json',
                    data: sendData,
                    beforeSend: function () {
                        $('#loaderModal').css('display', 'block');
                    },
                    success: function (response) {
                        $('#loaderModal').css('display', 'none');
                        if (response != "1") {

                            const dataSend3 = {
                                "medico": globMedicoSelect,
                                "especialidad": globCodEspecialidad,
                                "especialidadName": globDescEspecialidad,
                                "fechaSelect": globFechaSelect,
                                "HoraInit": globHoraInit,
                                "HoraFinish": globHoraFinish,
                                "CodConsultorio": globCodConsultorio,
                                "CitTime": globCitTime,
                                "codProcedimiento": globCodProcedimiento,
                                "autorizacion": globAutorizacion,
                                "primeraVez": tpcita,
                                "sede": globCodSede,
                                "sedeName": globDescSede,
                                "medicoName": globDescMedico
                            }

                            $.ajax({
                                url: '../../age/post/cit',
                                type: 'get',
                                dataType: 'json',
                                data: dataSend3,
                                beforeSend: function () {
                                    $('#loaderModal').css('display', 'block');
                                },
                                success: function (response) {
                                    $('#loaderModal').css('display', 'none');
                                    if (response.success == "0") { // SE AGENDO CORRECTAMENTE
                                        document.getElementById("messageCita").innerHTML = response.message;
                                        $("#paso_7").css("display", "none");
                                        $("#paso_8").css("display", "block");
                                    } else { // NO SE AGENDO CORRECTAMENTE
                                        Swal.fire({
                                            timer: 4000,
                                            icon: 'warning',
                                            title: response.message,
                                            showConfirmButton: true,
                                            confirmButtonText: 'Aceptar',
                                            confirmButtonColor: '#d42946',
                                            timerProgressBar: false,
                                        })
                                    }
                                },
                                error: function (jqXHR) { // ERROR AJAX
                                    $('#loaderModal').css('display', 'none');
                                    console.log('error!');
                                    Swal.fire({
                                        timer: 4000,
                                        icon: 'error',
                                        title: 'Ha ocurrido un error!',
                                        showConfirmButton: true,
                                        confirmButtonText: 'Aceptar',
                                        confirmButtonColor: '#d42946',
                                        timerProgressBar: false,
                                    })
                                }
                            });


                        } else {
                            Swal.fire({
                                icon: 'warning',
                                title: response.message,
                                showConfirmButton: true,
                                confirmButtonText: 'Aceptar',
                                confirmButtonColor: '#d42946',
                                timerProgressBar: false,
                            })
                        }
                    },
                    error: function (jqXHR) { // ERROR AJAX
                        $('#loaderModal').css('display', 'none');
                        console.log('error!');
                        Swal.fire({
                            icon: 'error',
                            title: 'Ha ocurrido un error!',
                            showConfirmButton: true,
                            confirmButtonText: 'Aceptar',
                            confirmButtonColor: '#d42946',
                            timerProgressBar: false,
                        })
                    }
                });

            }
        })


    } else {
        Swal.fire({
            icon: 'error',
            title: 'Por favor, selecciona una opción',
            showConfirmButton: true,
            confirmButtonText: 'Aceptar',
            confirmButtonColor: '#d42946',
            timerProgressBar: false,
        })
    }
});
